﻿//////////////////////////////////////////////
// CompositorNode.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Compositor ;
	class System ;
	class TargetOperations ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT CompositorNode : public nkExport::Exportable
	{		
		public :
		
			// Constructor, destructor
			CompositorNode (System* system) noexcept ;
			CompositorNode (const CompositorNode&) = delete ;
			virtual ~CompositorNode () ;

			// Getters
			nkMemory::StringView getName () const ;
			Compositor* getParentCompositor() const ;
			bool getActive () const ;
				
			// Setters
			void setName (const nkMemory::StringView& name) ;
			void setParentCompositor (Compositor* value) ;
			virtual void setActive (bool value) ;

			// TargetOperations management
			TargetOperations* addOperations () ;
			TargetOperations* getOperations (unsigned int index) const ;
			unsigned int getOperationsCount () const ;
			virtual void deleteOperations (unsigned int index) ;
			virtual void changeOperationsOrder (unsigned int fromIndex, unsigned int toIndex) ;

			// Rendering
			virtual void renderOperations () ;

			// Export / Import
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

			// Operators
			CompositorNode& operator= (const CompositorNode&) = delete ;

		protected :
		
			// Attributes
			nkMemory::BufferCast<nkMemory::UniquePtr<TargetOperations>> _operationsList ;
			System* _system ;

			// Information
			nkMemory::String _name ;
			Compositor* _parentCompositor ;

			// Flags
			bool _active ;

		private :

			// Allocations
			virtual nkMemory::UniquePtr<TargetOperations> _allocateTargetOperations () = 0 ;
	} ;
}